/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.common.entity;

import com.flemmli97.tenshilib.api.entity.IBeamEntity;
import com.flemmli97.tenshilib.common.entity.EntityUtil;
import com.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class EntityBeam
extends Entity
implements IBeamEntity {
    private LivingEntity shooter;
    protected int livingTicks;
    private int coolDown;
    private RayTraceResult hit;
    protected static final DataParameter<String> shooterUUID = EntityDataManager.func_187226_a(EntityBeam.class, (IDataSerializer)DataSerializers.field_187194_d);
    private final Predicate<Entity> notShooter = entity -> entity != this.getShooter() && EntityPredicates.field_180132_d.test(entity);

    public EntityBeam(EntityType<EntityBeam> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
    }

    public EntityBeam(EntityType<EntityBeam> type, World world, double x, double y, double z) {
        this(type, world);
        this.func_70107_b(x, y, z);
    }

    public EntityBeam(EntityType<EntityBeam> type, World world, LivingEntity shooter) {
        this(type, world, shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() - (double)0.1f, shooter.func_226281_cx_());
        this.shooter = shooter;
        this.field_70180_af.func_187227_b(shooterUUID, (Object)shooter.func_110124_au().toString());
        this.func_70101_b(shooter.field_70759_as, shooter.field_70125_A);
    }

    public void setRotationTo(double x, double y, double z, float accuracyMod) {
        double dx = x + this.field_70146_Z.nextGaussian() * (double)accuracyMod - this.func_226277_ct_();
        double dy = y + this.field_70146_Z.nextGaussian() * (double)accuracyMod - this.func_226278_cu_();
        double dz = z + this.field_70146_Z.nextGaussian() * (double)accuracyMod - this.func_226281_cx_();
        double dis = MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)dz, (double)dx) * 180.0 / Math.PI) - 90.0f;
        this.field_70125_A = (float)(Math.acos(dy / dis) * 180.0 / Math.PI) - 90.0f;
    }

    @Override
    public Vector3d startVec() {
        return this.func_213303_ch();
    }

    @Override
    public Vector3d hitVec() {
        return this.hit != null ? this.hit.func_216347_e() : this.startVec();
    }

    public float getRange() {
        return 32.0f;
    }

    public float radius() {
        return 0.0f;
    }

    public boolean piercing() {
        return false;
    }

    @Override
    public int livingTickMax() {
        return 20;
    }

    @Override
    public void updateYawPitch() {
        if (this.getHitVecFromShooter() && this.getShooter() != null) {
            LivingEntity e = this.getShooter();
            this.field_70125_A = e.field_70125_A;
            this.field_70177_z = e.field_70177_z;
            this.field_70127_C = e.field_70127_C;
            this.field_70126_B = e.field_70126_B;
            this.func_70107_b(e.func_226277_ct_(), e.func_226278_cu_() + (double)e.func_70047_e() - (double)0.1f, e.func_226281_cx_());
        }
    }

    public boolean getHitVecFromShooter() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < (double)Math.max(1048.0f, (this.getRange() + 2.0f) * (this.getRange() + 2.0f));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(shooterUUID, (Object)"");
    }

    public void func_70071_h_() {
        if (this.getShooter() != null && (this.hit == null || this.getHitVecFromShooter())) {
            this.hit = RayTraceUtils.entityRayTrace((Entity)(this.getHitVecFromShooter() ? this.getShooter() : this), this.getRange(), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, !this.piercing(), this.notShooter);
        }
        this.updateYawPitch();
        super.func_70071_h_();
        ++this.livingTicks;
        if (this.livingTicks >= this.livingTickMax()) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K && this.hit != null && --this.coolDown <= 0) {
            Vector3d offSetPosVec = this.func_213303_ch().func_178787_e(this.func_70040_Z().func_186678_a((double)this.radius()));
            List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.hit.func_216347_e().field_72450_a, this.hit.func_216347_e().field_72448_b, this.hit.func_216347_e().field_72449_c).func_186662_g(1.0));
            for (Entity entity : list) {
                EntityRayTraceResult raytraceresult;
                AxisAlignedBB axisalignedbb;
                Optional res;
                if (!entity.func_70067_L() || entity == this.getShooter() || !(res = (axisalignedbb = entity.func_174813_aQ().func_186662_g((double)this.radius() + (double)0.3f)).func_216365_b(offSetPosVec, this.hit.func_216347_e())).isPresent() || ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)(raytraceresult = new EntityRayTraceResult(entity)))) continue;
                this.onImpact((RayTraceResult)raytraceresult);
                this.coolDown = this.attackCooldown();
                if (this.piercing()) continue;
                return;
            }
        }
    }

    protected abstract void onImpact(RayTraceResult var1);

    public int livingTicks() {
        return this.livingTicks;
    }

    public int attackCooldown() {
        return 20;
    }

    public void func_70037_a(CompoundNBT compound) {
        this.field_70180_af.func_187227_b(shooterUUID, (Object)compound.func_74779_i("Shooter"));
        this.shooter = this.getShooter();
        this.livingTicks = compound.func_74762_e("LivingTicks");
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Shooter", (String)this.field_70180_af.func_187225_a(shooterUUID));
        compound.func_74768_a("LivingTicks", this.livingTicks);
    }

    @Override
    @Nullable
    public LivingEntity getShooter() {
        if (this.shooter == null && !((String)this.field_70180_af.func_187225_a(shooterUUID)).isEmpty()) {
            this.shooter = EntityUtil.findFromUUID(LivingEntity.class, this.field_70170_p, UUID.fromString((String)this.field_70180_af.func_187225_a(shooterUUID)));
        }
        return this.shooter;
    }
}

